/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.message;

import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.VWDesignerMessagePanel;
import filenet.vw.toolkit.design.message.VWDesignerValidationItem;
import filenet.vw.toolkit.design.message.VWValidationErrorListCellRenderer;
import filenet.vw.toolkit.design.message.images.VWImageLoader;
import filenet.vw.toolkit.design.message.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModelessDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class VWValidationResultsDialog
extends VWModelessDialog
implements IVWFrameInterface,
ActionListener {
    private static final int WINDOW_WIDTH = 450;
    private static final int WINDOW_HEIGHT = 400;
    private static final String HELP_VALIDATION = "designer/validationresultsdialog.htm";
    private static final String HELP_EXAMINE_REFERENCES = "designer/examinereferencesdialog.htm";
    private JLabel m_errorCountLabel = null;
    private JLabel m_warningCountLabel = null;
    private JComboBox m_errorComboBox = null;
    private JLabel m_levelLabel = null;
    private JLabel m_sourceLabel = null;
    private JLabel m_typeLabel = null;
    private JLabel m_displayingLabel = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private JButton m_gotoButton = null;
    private JTextArea m_messageTextArea = null;
    private JTextArea m_informationTextArea = null;
    private JButton m_revalidateButton = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWDesignerMessagePanel m_parentPanel = null;
    private Integer m_nErrorCount = null;
    private int m_nToolbarActionType = 651;
    private String m_helpPage = "designer/validationresultsdialog.htm";

    public VWValidationResultsDialog(VWAuthPropertyData authPropertyData, VWDesignerMessagePanel parentPanel) {
        super(authPropertyData.getMainContainer(), authPropertyData.getSessionInfo());
        this.m_authPropertyData = authPropertyData;
        this.m_parentPanel = parentPanel;
        this.setTitle(VWResource.s_validationResultsWindowTitle);
        if (!this.updateWindowPosition("validation_results_location", "validation_results_size")) {
            Dimension dim = VWStringUtils.stringToDimension("495, 445");
            if (dim == null) {
                this.updateWindowPosition(450, 400, 0);
            } else {
                this.updateWindowPosition(dim.width, dim.height, 0);
            }
        }
        this.createControls();
        this.addWindowListener(new VWWindowAdapter(this));
    }

    public void displayValidationMessages(VWDesignerValidationItem[] validationItems, int nErrorCount, int nWarningCount) {
        DefaultComboBoxModel<VWDesignerValidationItem> cbModel = new DefaultComboBoxModel<VWDesignerValidationItem>(validationItems);
        this.m_errorComboBox.setModel(cbModel);
        this.m_errorCountLabel.setText(Integer.toString(nErrorCount));
        this.m_warningCountLabel.setText(Integer.toString(nWarningCount));
        this.m_nErrorCount = new Integer(nErrorCount + nWarningCount);
        if (cbModel.getSize() > 0) {
            this.m_errorComboBox.setSelectedIndex(0);
        }
        this.setVisible(true);
    }

    public void setToolbarActionType(int nActionType) {
        this.m_nToolbarActionType = nActionType;
        switch (this.m_nToolbarActionType) {
            case 650: 
            case 651: {
                this.setTitle(VWResource.s_validationResultsWindowTitle);
                this.m_revalidateButton.setText(VWResource.s_revalidate);
                this.m_helpPage = HELP_VALIDATION;
                break;
            }
            case 655: {
                this.setTitle(VWResource.s_examinationResultsWindowTitle);
                this.m_revalidateButton.setText(VWResource.s_reexamine);
                this.m_helpPage = HELP_EXAMINE_REFERENCES;
            }
        }
    }

    public void setVisible(boolean bShow) {
        boolean bWasVisible = this.isVisible();
        if (bWasVisible && !bShow) {
            this.saveWindowPosition("validation_results_location", "validation_results_size");
        }
        super.setVisible(bShow);
    }

    public void windowClosing(WindowEvent event) {
        this.performExitItemAction(false);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_errorComboBox)) {
            this.handleComboBoxSelection();
        } else if (source.equals(this.m_upButton)) {
            this.handleUpButtonClick();
        } else if (source.equals(this.m_downButton)) {
            this.handleDownButtonClick();
        } else if (source.equals(this.m_gotoButton)) {
            this.handleGoToButtonClick();
        } else if (source.equals(this.m_revalidateButton)) {
            this.m_authPropertyData.getToolbarActionNotifier().notifyToolbarAction(this, this.m_nToolbarActionType);
        } else if (source.equals(this.m_closeButton)) {
            this.setVisible(false);
        } else if (source.equals(this.m_helpButton)) {
            VWHelp.displayPage(this.m_helpPage);
        }
    }

    private void createControls() {
        this.getContentPane().setLayout(new BorderLayout(4, 4));
        JPanel panel = this.createTopPanel();
        if (panel != null) {
            this.getContentPane().add((Component)panel, "First");
        }
        if ((panel = this.createMainPanel()) != null) {
            this.getContentPane().add((Component)panel, "Center");
        }
        if ((panel = this.createButtonPanel()) != null) {
            this.getContentPane().add((Component)panel, "Last");
        }
        super.updateComponentOrientation();
    }

    private JPanel createTopPanel() {
        try {
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            topPanel.add((Component)new JLabel(VWResource.s_numberOfErrors), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_errorCountLabel = new JLabel("0");
            topPanel.add((Component)this.m_errorCountLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            topPanel.add((Component)new JLabel(VWResource.s_numberOfWarnings), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            this.m_warningCountLabel = new JLabel("0");
            topPanel.add((Component)this.m_warningCountLabel, gbCons);
            return topPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            mainPanel.add((Component)this.createPanelOne(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            mainPanel.add((Component)this.createPanelTwo(), gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            mainPanel.add((Component)this.createPanelThree(), gbCons);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPanelOne() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)new JLabel(VWResource.s_nameColon), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_errorComboBox = new JComboBox();
            this.m_errorComboBox.setRenderer(new VWValidationErrorListCellRenderer());
            this.m_errorComboBox.addActionListener(this);
            panel.add((Component)this.m_errorComboBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_level)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_levelLabel = new JLabel();
            panel.add((Component)this.m_levelLabel, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_source)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_sourceLabel = new JLabel();
            panel.add((Component)this.m_sourceLabel, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_type)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_typeLabel = new JLabel();
            panel.add((Component)this.m_typeLabel, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_displaying)), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_displayingLabel = new JLabel();
            panel.add((Component)this.m_displayingLabel, gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPanelTwo() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 19;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_upButton = VWImageLoader.createIconButton("up.gif", VWResource.s_up);
            this.m_upButton.addActionListener(this);
            buttonPanel.add((Component)this.m_upButton, gbCons);
            ++gbCons.gridy;
            this.m_downButton = VWImageLoader.createIconButton("down.gif", VWResource.s_down);
            this.m_downButton.addActionListener(this);
            buttonPanel.add((Component)this.m_downButton, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(6, 2, 2, 2);
            this.m_gotoButton = VWImageLoader.createIconButton("goto.gif", VWResource.s_goto);
            this.m_gotoButton.addActionListener(this);
            buttonPanel.add((Component)this.m_gotoButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPanelThree() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_message)), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.7;
            this.m_messageTextArea = new JTextArea();
            this.m_messageTextArea.setLineWrap(true);
            this.m_messageTextArea.setWrapStyleWord(true);
            this.m_messageTextArea.setEditable(false);
            panel.add((Component)new JScrollPane(this.m_messageTextArea), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            panel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_information)), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.3;
            this.m_informationTextArea = new JTextArea();
            this.m_informationTextArea.setLineWrap(true);
            this.m_informationTextArea.setWrapStyleWord(true);
            this.m_informationTextArea.setEditable(false);
            panel.add((Component)new JScrollPane(this.m_informationTextArea), gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_revalidateButton = new JButton(VWResource.s_revalidate);
            this.m_revalidateButton.addActionListener(this);
            buttonPanel.add((Component)this.m_revalidateButton, gbCons);
            ++gbCons.gridx;
            this.m_closeButton = new JButton(VWResource.s_close);
            this.m_closeButton.addActionListener(this);
            buttonPanel.add((Component)this.m_closeButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void handleComboBoxSelection() {
        VWDesignerValidationItem validationItem = (VWDesignerValidationItem)this.m_errorComboBox.getSelectedItem();
        if (validationItem != null) {
            VWWorkflowDefinition wflDef = this.getWorkflow(validationItem);
            this.m_levelLabel.setText(validationItem.getLevelString());
            this.m_sourceLabel.setIcon(validationItem.getSourceIcon());
            this.m_sourceLabel.setText(validationItem.getSourceName());
            this.m_typeLabel.setIcon(validationItem.getErrorTypeIcon(wflDef));
            this.m_typeLabel.setText(validationItem.getErrorTypeString());
            int nIndex = this.m_errorComboBox.getSelectedIndex() + 1;
            this.m_displayingLabel.setText(VWResource.s_nofm.toString(new Integer(nIndex), this.m_nErrorCount));
            this.m_messageTextArea.setText(validationItem.getMessage());
            this.m_informationTextArea.setText(validationItem.getInfo());
        }
        this.updateButtonState();
    }

    private VWWorkflowDefinition getWorkflow(VWDesignerValidationItem validationItem) {
        try {
            String name = validationItem.getSourceName();
            if (VWStringUtils.compare(name, VWResource.s_blankName) == 0) {
                name = "";
            }
            return this.m_authPropertyData.getDesignerCoreData().getProcessMenuHelper().getWorkflowCollectionDefinition().getWorkflow(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void handleUpButtonClick() {
        int nIndex = this.m_errorComboBox.getSelectedIndex();
        this.m_errorComboBox.setSelectedIndex(nIndex - 1);
        this.updateButtonState();
    }

    private void handleDownButtonClick() {
        int nIndex = this.m_errorComboBox.getSelectedIndex();
        this.m_errorComboBox.setSelectedIndex(nIndex + 1);
        this.updateButtonState();
    }

    private void handleGoToButtonClick() {
        VWDesignerValidationItem validationItem;
        if (this.m_parentPanel != null && (validationItem = (VWDesignerValidationItem)this.m_errorComboBox.getSelectedItem()) != null) {
            this.m_parentPanel.notifyListeners(validationItem, this.getWorkflow(validationItem));
        }
    }

    private void updateButtonState() {
        int nIndex = this.m_errorComboBox.getSelectedIndex();
        if (nIndex == 0) {
            this.m_upButton.setEnabled(false);
        } else {
            this.m_upButton.setEnabled(true);
        }
        if (nIndex == this.m_errorComboBox.getModel().getSize() - 1) {
            this.m_downButton.setEnabled(false);
        } else {
            this.m_downButton.setEnabled(true);
        }
        this.m_gotoButton.setEnabled(true);
    }

    private void performExitItemAction(boolean bCloseWindow) {
        if (bCloseWindow) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
        }
    }
}

